// StreamCatcherDemoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "sc510.h"
#include "sc510Dlg.h"


#define COMPILE_MULTIMON_STUBS

#include <MULTIMON.H>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID Dbg( CHAR* pszStr, ... )
{
	char szData[ MAX_PATH ] = "[SC] ";

	va_list args;

	va_start( args, pszStr );

	_vsnprintf( szData + 5, sizeof( szData ) - 1, pszStr, args );

	va_end( args );

    strcat( szData, "\n" );

	OutputDebugString( szData );
}

// INITIALIZE STATIC CLASS VARIABLE 
//
sc510Dlg*	sc510Dlg::s_psc510Dlg = 0;

//  FORMAT CHANGED CALLBACK FUNCTION
//
QRETURN on_process_format_changed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample,  ULONG nAudioSampleFrequency, PVOID pUserData )
{
	Dbg("format changed Detected  \n");

	sc510Dlg* m_pMainDialog = sc510Dlg::s_psc510Dlg;

	ULONG i = (ULONG)(pUserData);

	// OUTPUT FORMAT CHANGED MESSAGE
	//
	CHAR strVideoInput[ MAX_PATH ] = { 0 };

	CHAR strAudioInput[ MAX_PATH ] = { 0 };

	CHAR strFrameType[ MAX_PATH ] = { 0 }; 

    UINT nVH = 0;

    if ( nVideoInput == 0 ) { sprintf( strVideoInput, "COMPOSITE" ); }
 	
	if ( nVideoInput == 1 ) { sprintf( strVideoInput, "SVIDEO" ); }
	
	if ( nVideoInput == 2 ) { sprintf( strVideoInput, "HDMI" );}

    if ( nVideoInput == 3 ) { sprintf( strVideoInput, "DVI_D" );}
	
	if ( nVideoInput == 4 ) { sprintf( strVideoInput, "COMPONENTS (YCBCR)" );}
	
	if ( nVideoInput == 5 ) { sprintf( strVideoInput, "DVI_A (RGB / VGA)" );}
	
    if ( nVideoInput == 6 ) { sprintf( strVideoInput, "SDI" );}
	
	if ( nVideoInput == 7 ) { sprintf( strVideoInput, "AUTO" );}

    if ( nAudioInput == 0 ) { sprintf( strAudioInput, "EMBEDDED_AUDIO" );}
	
	if ( nAudioInput == 1 ) { sprintf( strAudioInput, "LINE_IN" );}

    if ( bVideoIsInterleaved == TRUE ) { nVH = nVideoHeight / 2; } else { nVH = nVideoHeight; }

    if ( bVideoIsInterleaved == TRUE ) { sprintf( strFrameType, " I " ); } else { sprintf( strFrameType, " P " ); }

	m_pMainDialog->m_nVideoWidth[ i ] = nVideoWidth;

	m_pMainDialog->m_nVideoHeight[ i ] = nVideoHeight;

	m_pMainDialog->m_bVideoIsInterleaved[ i ] = bVideoIsInterleaved;

	m_pMainDialog->m_dVideoFrameRate[ i ] = dVideoFrameRate;

	m_pMainDialog->m_nAudioChannels[ i ] = nAudioChannels;

	m_pMainDialog->m_nAudioBitsPerSample[ i ] = nAudioBitsPerSample;

	m_pMainDialog->m_nAudioSampleFrequency[ i ] = nAudioSampleFrequency;

	m_pMainDialog->m_strFormatChangedOutput[ i ].Format( "INFO : %d x %d%s @%2.3f FPS , %d CH x %d BITS x %d HZ ,  VIDEO INPUT : %s ,  AUDIO INPUT : %s",

													nVideoWidth,

													nVH,

													strFrameType,

													dVideoFrameRate,

													nAudioChannels,

													nAudioBitsPerSample,

													nAudioSampleFrequency,

													strVideoInput,

													strAudioInput ); 


    // NO SOURCE
    //
    if ( nVideoWidth == 0 && 
		
		 nVideoHeight == 0 &&

		 dVideoFrameRate == 0.0 &&

		 nAudioChannels == 0 &&

		 nAudioBitsPerSample == 0 &&

		 nAudioSampleFrequency == 0 ) {

		m_pMainDialog->m_bNoSignal[ i ] = TRUE;		
	}
    else {

		m_pMainDialog->m_bNoSignal[ i ] = FALSE;		
    }

	m_pMainDialog->SetTimer( 0x00000000, 1, NULL );	

    return QCAP_RT_OK;
}    

// NO SIGNAL DETEACTED CALLBACK FUNCTION
//
QRETURN on_process_no_signal_detected( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	Dbg("No Signal Detected  \n");

	sc510Dlg* m_pMainDialog = sc510Dlg::s_psc510Dlg;

	ULONG i = (ULONG)(pUserData);

	m_pMainDialog->m_nVideoWidth[ i ] = 0;

	m_pMainDialog->m_nVideoHeight[ i ] = 0;

	m_pMainDialog->m_bVideoIsInterleaved[ i ] = FALSE;

	m_pMainDialog->m_dVideoFrameRate[ i ] = 0.0;

	m_pMainDialog->m_nAudioChannels[ i ] = 0;

	m_pMainDialog->m_nAudioBitsPerSample[ i ] = 0;

	m_pMainDialog->m_nAudioSampleFrequency[ i ] = 0;

	m_pMainDialog->SetTimer( 0x00000000, 1, NULL );	

	return QCAP_RT_OK;
}

// SIGNAL REMOVED CALLBACK FUNCTION
//
QRETURN on_process_signal_removed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{

	Dbg(" Signal Removed \n");
	
	sc510Dlg* m_pMainDialog = sc510Dlg::s_psc510Dlg;

	ULONG i = (ULONG)(pUserData);

	m_pMainDialog->m_nVideoWidth[ i ] = 0;

	m_pMainDialog->m_nVideoHeight[ i ] = 0;

	m_pMainDialog->m_bVideoIsInterleaved[ i ] = FALSE;

	m_pMainDialog->m_dVideoFrameRate[ i ] = 0.0;

	m_pMainDialog->m_nAudioChannels[ i ] = 0;

	m_pMainDialog->m_nAudioBitsPerSample[ i ] = 0;

	m_pMainDialog->m_nAudioSampleFrequency[ i ] = 0;

	m_pMainDialog->SetTimer( 0x00000000, 1, NULL );	

    return QCAP_RT_OK;
}    

// PREVIEW VIDEO CALLBACK FUNCTION
//
QRETURN on_process_preview_video_buffer( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
	sc510Dlg* m_pMainDialog = sc510Dlg::s_psc510Dlg;

	ULONG i = (ULONG)(pUserData);

	EnterCriticalSection( &m_pMainDialog->m_hShareRecordAccessCriticalSection );

	if( m_pMainDialog->m_nShareRecordState > 0x00000000 ) {

		if( i == 0 ) {

			QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER( 0, QCAP_COLORSPACE_TYEP_YUY2, m_pMainDialog->m_nVideoWidth[ i ], m_pMainDialog->m_nVideoHeight[ i ], pFrameBuffer, nFrameBufferLen );
		}
		if( i == 1 ) {

			QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER( 0, QCAP_COLORSPACE_TYEP_YUY2, m_pMainDialog->m_nVideoWidth[ i ], m_pMainDialog->m_nVideoHeight[ i ], pFrameBuffer, nFrameBufferLen );
		}
		if( i == 0 ) {

			QCAP_SET_VIDEO_3D_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0 );
		}
	}
	LeaveCriticalSection( &m_pMainDialog->m_hShareRecordAccessCriticalSection );
	
    return QCAP_RT_OK;
}

// PREVIEW AUDIO CALLBACK FUNCTION
//
QRETURN on_process_preview_audio_buffer( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
	sc510Dlg* m_pMainDialog = sc510Dlg::s_psc510Dlg;

	ULONG i = (ULONG)(pUserData);
	
	EnterCriticalSection( &m_pMainDialog->m_hShareRecordAccessCriticalSection );

	if( m_pMainDialog->m_nShareRecordState > 0x00000000 ) {

		if( i == 0 ) {

			QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, pFrameBuffer, nFrameBufferLen );
		}
	}
	LeaveCriticalSection( &m_pMainDialog->m_hShareRecordAccessCriticalSection );

    return QCAP_RT_OK;
}

/////////////////////////////////////////////////////////////////////////////
// sc510Dlg dialog

sc510Dlg::sc510Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(sc510Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(sc510Dlg)
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void sc510Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(sc510Dlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(sc510Dlg, CDialog)
	//{{AFX_MSG_MAP(sc510Dlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_ERASEBKGND()
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_WM_CLOSE()
//	ON_WM_LBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// sc510Dlg message handlers

void sc510Dlg::OnOK() 
{
	// TODO: Add extra validation here
	
	// CDialog::OnOK();
}

void sc510Dlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	// CDialog::OnCancel();
}

BOOL sc510Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	sc510Dlg::s_psc510Dlg = this;

	// INITIALIZE MEMBER VARIABLES
	//
	{	

		for ( ULONG i = 0 ; i < 2; i++ ) {

			  m_hVideoDevice[ i ] = 0;

	   		  m_nVideoWidth[ i ] = 0;

		      m_nVideoHeight[ i ] = 0;

		      m_bVideoIsInterleaved[ i ] = FALSE;

		      m_dVideoFrameRate[ i ] = 0.0;

		      m_nAudioChannels[ i ] = 0;

		      m_nAudioBitsPerSample[ i ] = 0;

		      m_nAudioSampleFrequency[ i ] = 0;
		
		      m_bNoSignal[ i ] = TRUE;
		}

		m_nShareRecordState = 0x00000000;

		InitializeCriticalSection( &m_hShareRecordAccessCriticalSection );


		// GET DEFAULT RECORD PATH
		// 
		{	BYTE pData[ MAX_PATH ]; DWORD dwType = REG_SZ; DWORD dwData = MAX_PATH;

			HKEY hKey = NULL; RegOpenKey( HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", &hKey );

			RegQueryValueEx( hKey, "Personal", NULL, &dwType, pData, &dwData );

			RegCloseKey( hKey );

			CHAR psz[ MAX_PATH ] = "";

			if ( strlen( (CHAR*)(pData) ) ) {

				m_strDefaultPath.Format( "%s", (CHAR*)(pData) );
			}
			else {

				m_strDefaultPath.Format( "%s", "" );
			}

			m_strRecordPath.Format( "%s\\My Records", m_strDefaultPath );

			CreateDirectory( m_strRecordPath, NULL );
		}

		m_strRecordFileName = "";
	}
	// INITIALIZE COM RESOURCE
	//
	{	HRESULT hr = CoInitialize( NULL );
	}
	// INITIALIZE USER INTERFACE RESOURCE
	//
	{	m_oChannelWindows[ 0 ].Create( NULL, "MyChannelWindow#01", WS_CHILD | WS_VISIBLE, CRect( 0, 0, 960, 540 ), this, 0x00000001, NULL ); // VIDEO WINDOW

		m_oChannelWindows[ 1 ].Create( NULL, "MyChannelWindow#01", WS_CHILD | WS_VISIBLE, CRect( 0, 0, 960, 540 ), this, 0x00000002, NULL ); // BACKGROUND WINDOW

		m_oCloneWindows.Create( NULL, "MyCloneWindow#01", WS_CHILD | WS_VISIBLE, CRect( 0, 0, 0, 0 ), this, 0x10000001, NULL ); // BACKGROUND WINDOW

		// INITIALIZE MAIN WINDOW
		//
		{	CRect oWindowRect; GetWindowRect( &oWindowRect );

			CRect oClientRect; GetClientRect( &oClientRect );

			ULONG cx = oWindowRect.Width() - oClientRect.Width();		// GET DEFAULT BOUNDARY WIDTH OF DIALOG

			ULONG cy = oWindowRect.Height() - oClientRect.Height();		// GET DEFAULT BOUNDARY HEIGHT OF DIALOG

			MoveWindow( 0, 0, cx + 960, cy + 540 );

			m_oChannelWindows[ 0 ].MoveWindow( 0, 0, cx + 960, cy + 540 );

			m_oChannelWindows[ 1 ].MoveWindow( 0, 0, cx + 960, cy + 540 );

			m_oChannelWindows[ 1 ].ShowWindow( FALSE );

			m_oCloneWindows.MoveWindow( cx + 960 - 320, cy + 540 - 240, 320, 240 );

			m_oCloneWindows.ShowWindow( FALSE );
		}

		// INITIALIZE SETUP DIALOG
		//
		{	HMONITOR hMonitor = MonitorFromWindow( m_hWnd, MONITOR_DEFAULTTONEAREST );			

			MONITORINFO sMonitorInfo = { sizeof(MONITORINFO), }; 
			
			GetMonitorInfo( hMonitor, &sMonitorInfo );

			CRect oMonitorRect = sMonitorInfo.rcWork;			
			
			m_oSetupDialog.Create( IDD_SETUP_DIALOG, this );

			CRect oWindowRect; m_oSetupDialog.GetWindowRect( &oWindowRect );

			CRect oClientRect; m_oSetupDialog.GetClientRect( &oClientRect );

			ULONG cx = oWindowRect.Width() - oClientRect.Width();		// GET DEFAULT BOUNDARY WIDTH OF DIALOG

			ULONG cy = oWindowRect.Height() - oClientRect.Height();		// GET DEFAULT BOUNDARY HEIGHT OF DIALOG

			m_oSetupDialog.SetWindowPos( &(CWnd::wndTop), (oMonitorRect.Width() - (960 + cx)) / 2,

														  (oMonitorRect.Height() - (105 + 40 + cy)),
														  
														  (cx + 960), 

														  (cy + 400),
														  
														  (NULL));
			m_oSetupDialog.ShowWindow( TRUE );
		}

		SetWindowText( "" DEFAULT_PRODUCT ", " DEFAULT_PRODUCT_VERSION );	
	}

	HwInitialize();	

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void sc510Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR sc510Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

BOOL sc510Dlg::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default

	CRect rect_client;	GetClientRect( &rect_client );

	CBrush brush_fill_rect( RGB(0, 0, 0) );

	pDC->FillRect( &rect_client, &brush_fill_rect );

	return CWnd::OnEraseBkgnd(pDC);
}

BOOL sc510Dlg::OnLButtonDblClk_ChannelWindow() 
{
	// TODO: Add your message handler code here and/or call default
	
	HMONITOR hMonitor = MonitorFromWindow( m_hWnd, MONITOR_DEFAULTTONEAREST );	

	MONITORINFO sMonitorInfo = { sizeof(MONITORINFO), }; 

	GetMonitorInfo( hMonitor, &sMonitorInfo );

	CRect oMonitorRect = sMonitorInfo.rcMonitor;

	CRect oWindowRect; GetWindowRect( &oWindowRect );

	if ( oWindowRect.Width() < oMonitorRect.Width() ) {

		m_oChannelWindows[ 0 ].MoveWindow( 0, 0, oMonitorRect.Width(), oMonitorRect.Height() );

		m_oChannelWindows[ 1 ].MoveWindow( 0, 0, oMonitorRect.Width(), oMonitorRect.Height() );

		m_oCloneWindows.MoveWindow( oMonitorRect.Width() - 320, oMonitorRect.Height() - 240, 320, 240 );

		MoveWindow( oMonitorRect );
	}
	else {

		m_oChannelWindows[ 0 ].MoveWindow( 0, 0, 960, 540 );

		m_oChannelWindows[ 1 ].MoveWindow( 0, 0, 960, 540 );

		m_oCloneWindows.MoveWindow( 960 - 320, 540 - 240, 320, 240 );

		MoveWindow( (oMonitorRect.Width() - 960) / 2, (oMonitorRect.Height() - 540) / 2, 960, 540 );	
	}	

	return TRUE;
}

void sc510Dlg::OnDestroy() 
{
	// UNINITIALIZE DEVICE RESOURCE
	//
	{	HwUninitialize();
	}
	// UNINITIALIZE USER INTERFACE RESOURCE
	//
	{	m_oChannelWindows[ 0 ].DestroyWindow();

		m_oChannelWindows[ 1 ].DestroyWindow();

		m_oSetupDialog.DestroyWindow();
	}
	// UNINITIALIZE COM RESOURCE
	//
	{	CoUninitialize();
	}
}

BOOL sc510Dlg::HwInitialize()
{
	// CALLBACK FUNCTION
	//        
	PF_FORMAT_CHANGED_CALLBACK m_pFormatChangedCB[ 2 ] = { 0 };

	PF_VIDEO_PREVIEW_CALLBACK  m_pPreviewVideoCB[ 2 ] = { 0 };

	PF_AUDIO_PREVIEW_CALLBACK m_pPreviewAudioCB[ 2 ]  = { 0 };
   
	PF_NO_SIGNAL_DETECTED_CALLBACK m_pNoSignalDetectedCB[ 2 ] = { 0 };

	PF_SIGNAL_REMOVED_CALLBACK m_pSignalRemovedCB[ 2 ] = { 0 };

	for ( ULONG i = 0; i < 2; i++ ) { 

		// CREATE CAPTURE DEVICE
		//
		if( i == 0 ) { QCAP_CREATE( "SA7160 PCI", i, m_oSetupDialog.m_statLeftWindow.m_hWnd, &(m_hVideoDevice[ i ]), TRUE, FALSE ); }

		if( i == 1 ) { QCAP_CREATE( "SA7160 PCI", i, m_oSetupDialog.m_statRightWindow.m_hWnd, &(m_hVideoDevice[ i ]), TRUE, FALSE ); }


		// REGISTER FORMAT CHANGED CALLBACK FUNCTION
		// 
		m_pFormatChangedCB[ i ] = on_process_format_changed;

		QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_hVideoDevice[ i ], m_pFormatChangedCB[ i ], (PVOID)(i) );

		// REGISTER PREVIEW VIDEO CALLBACK FUNCTION
		// 
		m_pPreviewVideoCB[ i ] = on_process_preview_video_buffer;

		QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_hVideoDevice[ i ], m_pPreviewVideoCB[ i ], (PVOID)(i) );

		// REGISTER PREVIEW AUDIO CALLBACK FUNCTION
		//
		m_pPreviewAudioCB[ i ] = on_process_preview_audio_buffer;

		QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_hVideoDevice[ i ], m_pPreviewAudioCB[ i ], (PVOID)(i) );
	
		// REGISTER NO SIGNAL DETECTED CALLBACK FUNCTION
		//
		m_pNoSignalDetectedCB[ i ] = on_process_no_signal_detected;

		QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_hVideoDevice[ i ], m_pNoSignalDetectedCB[ i ], (PVOID)(i) );

		// REGISTER SIGNAL REMOVED CALLBACK FUNCTION
		//
		m_pSignalRemovedCB[ i ] =  on_process_signal_removed;

		QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_hVideoDevice[ i ], m_pSignalRemovedCB[ i ], (PVOID)(i) );

		QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice[ i ], 0 );

		QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ i ], 100 );

		QCAP_RUN( m_hVideoDevice[ i ] );	

	}

	// INITIALIZE SHARE RECORDING RESOURCE
	// 
	if ( m_hVideoDevice[ 0 ] && m_hVideoDevice[ 1 ] ) {}

	{	double fps = m_dVideoFrameRate[ 0 ];

		if( m_bVideoIsInterleaved[ 0 ] ) {

			fps /= 2;
		}
		QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264_3D, QCAP_COLORSPACE_TYEP_YUY2, m_nVideoWidth[ 0 ], m_nVideoHeight[ 0 ], fps, QCAP_RECORD_MODE_CBR, 8000, 4000000, 30, 0, 0, m_oChannelWindows[ 0 ], TRUE, FALSE );

		QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, m_nAudioChannels[ 0 ], m_nAudioBitsPerSample[ 0 ], m_nAudioSampleFrequency[ 0 ] );

		//QCAP_START_SHARE_RECORD( 0, "3D.TS", QCAP_RECORD_FLAG_ENCODE | QCAP_RECORD_FLAG_FILE );

		QCAP_START_SHARE_RECORD( 0, "3D.TS", QCAP_RECORD_FLAG_DISPLAY );

		EnterCriticalSection( &m_hShareRecordAccessCriticalSection );

		m_nShareRecordState = 0x00000001;

		LeaveCriticalSection( &m_hShareRecordAccessCriticalSection );
	}

	return TRUE;
}


BOOL sc510Dlg::HwUninitialize()
{	

	// UNINITIALIZE DEVICE RESOURCE
	// 
	{	EnterCriticalSection( &m_hShareRecordAccessCriticalSection );

		m_nShareRecordState = 0x00000000;

		LeaveCriticalSection( &m_hShareRecordAccessCriticalSection );

		QCAP_STOP_SHARE_RECORD( 0 );
	}

	for ( ULONG i = 0; i < 2; i++ ) {

		if ( m_hVideoDevice[ i ] != 0 ) {

			QCAP_STOP( m_hVideoDevice[ i ] );

			QCAP_DESTROY( m_hVideoDevice[ i ] );

			m_hVideoDevice[ i ] = NULL;
		}	
	}

	DeleteCriticalSection( &m_hShareRecordAccessCriticalSection );

	return TRUE;
}


void sc510Dlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	
	if( nIDEvent == 0x00000000 )
	{
		KillTimer ( 0x00000000 );

		for ( ULONG i = 0; i < 2; i++ ) {

			if( m_bNoSignal[i] )
			{
				if ( i == 0 ) { m_oSetupDialog.m_editDeviceFormatInformation_1.SetWindowText( _T("INFO :...") ); }

				if ( i == 1 ) { m_oSetupDialog.m_editDeviceFormatInformation_2.SetWindowText( _T("INFO :...") ); }

				m_oChannelWindows[ 0 ].ShowWindow( FALSE );

				m_oChannelWindows[ 1 ].ShowWindow( TRUE );	
			}
			else
			{
				if ( i == 0 ) { m_oSetupDialog.m_editDeviceFormatInformation_1.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 0 ] ); }

				if ( i == 1 ) { m_oSetupDialog.m_editDeviceFormatInformation_2.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 1 ] ); }

				m_oChannelWindows[ 0 ].ShowWindow( TRUE );

				m_oChannelWindows[ 1 ].ShowWindow( FALSE );	
			}

		}

	}


	CDialog::OnTimer(nIDEvent);
}

